<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Domain extends Eloquent {

	protected $table = 'domains';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->belongsTo('App\Models\Customer', 'customer_id');
	}

	public function page()
	{
		return $this->belongsTo('App\Models\Page', 'page_id');
	}

}