<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Page extends Eloquent {

	protected $table = 'pages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function template()
	{
		return $this->belongsTo('App\Models\Template', 'template_id');
	}

	public function customer()
	{
		return $this->belongsTo('App\Models\Customer', 'customer_id');
	}

}