<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AlimentVague extends Eloquent {

	protected $table = 'aliments_vagues';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'statut', 'id_vague', 'id_aliment');
	protected $visible = array('slug', 'statut', 'id_vague', 'id_aliment');

	public function aliment()
	{
		return $this->belongsTo('App\Models\Aliment', 'id_aliment');
	}

	public function vague()
	{
		return $this->belongsTo('App\Models\Vague', 'id_vague');
	}

}