<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EquivalenceUnite extends Eloquent {

	protected $table = 'equivalences_unites';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_uniteDepart', 'id_uniteArrive', 'valeur', 'statut');
	protected $visible = array('slug', 'id_uniteDepart', 'id_uniteArrive', 'valeur', 'statut');

	public function unite()
	{
		return $this->belongsTo('App\Models\Unite', 'id_uniteDepart');
	}

}