<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Espece extends Eloquent {

	protected $table = 'especes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_espece', 'id_entreprise', 'nom', 'description', 'statut');
	protected $visible = array('slug', 'id_espece', 'id_entreprise', 'nom', 'description', 'statut');

	public function especeMere()
	{
		return $this->belongsTo('App\Models\Espece', 'id_espece');
	}

	public function especeFille()
	{
		return $this->hasMany('App\Models\Espece', 'id_espece');
	}

	public function entreprise()
	{
		return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
	}

	public function vague()
	{
		return $this->hasMany('App\Models\Vague', 'id_espece');
	}

}