<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class NMadmin extends Eloquent {

	protected $table = 'nm_admins';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'matricule', 'email', 'passWord', 'name', 'statut', 'telephone');
	protected $visible = array('slug', 'matricule', 'email', 'passWord', 'name', 'statut', 'telephone');

	public function entreprise()
	{
		return $this->hasMany('App\Models\Entreprise', 'id_NMadmin');
	}

	public function versement()
	{
		return $this->hasMany('App\Models\Versement', 'id_nm_admin');
	}

}