<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PassageVeterinaire extends Eloquent {

	protected $table = 'passages_veterinaires';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_utilisateurNiveau4', 'prix', 'date', 'anomalie', 'prescription', 'commentaire', 'statut');
	protected $visible = array('slug', 'id_utilisateurNiveau4', 'prix', 'date', 'anomalie', 'prescription', 'commentaire', 'statut');

	public function utilisateurNiveau4()
	{
		return $this->belongsTo('App\Models\UtilisateurNiveau4', 'id_utilisateurNiveau4');
	}

	public function passageVeterinaireVague()
	{
		return $this->hasMany('App\Models\PassageVeterinaireVague', 'id_passage_veterinaire');
	}

	public function depense()
	{
		return $this->hasMany('App\Models\Depense', 'id_passage_veterinaire');
	}

}