<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Versement extends Eloquent {

	protected $table = 'versements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_entreprise', 'id_nm_admin', 'dateDebut', 'dateFin', 'nombreUtilisateur', 'nombreJour', 'nombreVague', 'montant', 'statut');
	protected $visible = array('slug', 'id_nm_admin', 'dateDebut', 'dateFin', 'nombreUtilisateur', 'nombreJour', 'nombreVague', 'montant', 'statut');

	public function entreprise()
	{
		return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
	}

	public function nm_admin()
	{
		return $this->belongsTo('App\Models\NMadmin', 'id_nm_admin');
	}

}