<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesMenVisitsTable extends Migration {

	public function up()
	{
		Schema::create('sales_men_visits', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code')->nullable();
			$table->integer('sales_man_id');
			$table->integer('customer_id');
			$table->date('date')->nullable();
			$table->string('title')->nullable();
			$table->text('notes')->nullable();
			$table->float('cost')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('sales_men_visits');
	}
}