<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoryItemsTable extends Migration {

	public function up()
	{
		Schema::create('inventory_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('inventory_id');
			$table->integer('item_id');
			$table->double('amount')->default('0');
			$table->double('reserved_amount')->default('0');
			$table->float('unit_price')->default('0');
			$table->float('purchase_price')->default('0');
			$table->float('sale_price')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('inventory_items');
	}
}