<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJournalCodesTable extends Migration {

	public function up()
	{
		Schema::create('journal_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('journal_code_setting_id');
			$table->string('model')->nullable();
			$table->string('alias')->nullable();
			$table->integer('latest_number')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('journal_codes');
	}
}