<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('details', 255);
			$table->integer('state')->nullable();
			$table->integer('order_id')->unsigned();
			$table->integer('driver_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->decimal('price', 10,2);
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}