<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSeoTable extends Migration {

	public function up()
	{
		Schema::create('seo', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->string('title');
			$table->mediumText('meta_description')->nullable();
			$table->longText('meta_keywords');
			$table->text('meta_thumbnail')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('seo');
	}
}