<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'domain');

	public function countries()
	{
		return $this->hasMany('CountryGroup');
	}

	public function sections()
	{
		return $this->hasMany('Section');
	}

}