<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFoodsTable extends Migration {

	public function up()
	{
		Schema::create('foods', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('discription');
			$table->double('price');
			$table->string('discount_price');
			$table->tinyInteger('publish')->default('0');
			$table->integer('category_id')->unsigned()->index();
			$table->integer('calories');
			$table->time('prepration_time');
			$table->integer('size_id')->unsigned()->index();
			$table->tinyInteger('sold_out');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('foods');
	}
}