<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImagesTable extends Migration {

	public function up()
	{
		Schema::create('images', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('image');
			$table->string('imageable_id');
			$table->string('imageable_type', 191);
			$table->enum('type', array('image', 'video'));
			$table->string('title');
		});
	}

	public function down()
	{
		Schema::drop('images');
	}
}