<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTable extends Migration {

	public function up()
	{
		Schema::create('places', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('category_id')->unsigned();
			$table->string('name', 191);
			$table->double('distance')->default('0.0');
			$table->string('lat');
			$table->string('long');
			$table->string('address');
			$table->string('avg_visit_time');
			$table->longText('religious_desc');
			$table->longText('historical_desc');
			$table->string('virtue', 191);
			$table->longText('desc')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('places');
	}
}