<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191);
			$table->string('phone', 191);
			$table->string('avatar', 191)->nullable();
			$table->string('email', 191)->nullable();
			$table->string('code')->nullable();
			$table->string('lat')->nullable();
			$table->string('long')->nullable();
			$table->string('address')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}