<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('type_translations', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('period_transaltions', function(Blueprint $table) {
			$table->foreign('period_id')->references('id')->on('periods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('taskeen_type_transaltions', function(Blueprint $table) {
			$table->foreign('taskeen_type_translations')->references('id')->on('taskeen_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('facility_tranlsations', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mark_translations', function(Blueprint $table) {
			$table->foreign('mark_id')->references('id')->on('marks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_tanslations', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('city_tranlsations', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ticket_type_translations', function(Blueprint $table) {
			$table->foreign('ticket_type_id')->references('id')->on('ticket_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_method_translations', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('payment_methods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('instructions', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('instruction_translations', function(Blueprint $table) {
			$table->foreign('instruction_id')->references('id')->on('instructions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('question_translations', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('blog_translations', function(Blueprint $table) {
			$table->foreign('blog_id')->references('id')->on('blogs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('blog_images', function(Blueprint $table) {
			$table->foreign('blog_id')->references('id')->on('blogs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unit_periods', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('unit_periods', function(Blueprint $table) {
			$table->foreign('period_id')->references('id')->on('periods')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('unit_taskeen_types', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unit_taskeen_types', function(Blueprint $table) {
			$table->foreign('taskeen_type_id')->references('id')->on('taskeen_types')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('unit_images', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('unit_facilites', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('unit_facilites', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unit_marks', function(Blueprint $table) {
			$table->foreign('mark_id')->references('id')->on('marks')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('unit_marks', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('unit_reservations', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('unit_reservations', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('unit_reservations', function(Blueprint $table) {
			$table->foreign('period_id')->references('id')->on('periods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unit_payments', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unit_payments', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('type_translations', function(Blueprint $table) {
			$table->dropForeign('type_translations_type_id_foreign');
		});
		Schema::table('period_transaltions', function(Blueprint $table) {
			$table->dropForeign('period_transaltions_period_id_foreign');
		});
		Schema::table('taskeen_type_transaltions', function(Blueprint $table) {
			$table->dropForeign('taskeen_type_transaltions_taskeen_type_translations_foreign');
		});
		Schema::table('facility_tranlsations', function(Blueprint $table) {
			$table->dropForeign('facility_tranlsations_facility_id_foreign');
		});
		Schema::table('mark_translations', function(Blueprint $table) {
			$table->dropForeign('mark_translations_mark_id_foreign');
		});
		Schema::table('country_tanslations', function(Blueprint $table) {
			$table->dropForeign('country_tanslations_country_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('city_tranlsations', function(Blueprint $table) {
			$table->dropForeign('city_tranlsations_city_id_foreign');
		});
		Schema::table('ticket_type_translations', function(Blueprint $table) {
			$table->dropForeign('ticket_type_translations_ticket_type_id_foreign');
		});
		Schema::table('payment_method_translations', function(Blueprint $table) {
			$table->dropForeign('payment_method_translations_account_id_foreign');
		});
		Schema::table('instructions', function(Blueprint $table) {
			$table->dropForeign('instructions_type_id_foreign');
		});
		Schema::table('instruction_translations', function(Blueprint $table) {
			$table->dropForeign('instruction_translations_instruction_id_foreign');
		});
		Schema::table('question_translations', function(Blueprint $table) {
			$table->dropForeign('question_translations_question_id_foreign');
		});
		Schema::table('blog_translations', function(Blueprint $table) {
			$table->dropForeign('blog_translations_blog_id_foreign');
		});
		Schema::table('blog_images', function(Blueprint $table) {
			$table->dropForeign('blog_images_blog_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_type_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_city_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_country_id_foreign');
		});
		Schema::table('unit_periods', function(Blueprint $table) {
			$table->dropForeign('unit_periods_unit_id_foreign');
		});
		Schema::table('unit_periods', function(Blueprint $table) {
			$table->dropForeign('unit_periods_period_id_foreign');
		});
		Schema::table('unit_taskeen_types', function(Blueprint $table) {
			$table->dropForeign('unit_taskeen_types_unit_id_foreign');
		});
		Schema::table('unit_taskeen_types', function(Blueprint $table) {
			$table->dropForeign('unit_taskeen_types_taskeen_type_id_foreign');
		});
		Schema::table('unit_images', function(Blueprint $table) {
			$table->dropForeign('unit_images_unit_id_foreign');
		});
		Schema::table('unit_facilites', function(Blueprint $table) {
			$table->dropForeign('unit_facilites_facility_id_foreign');
		});
		Schema::table('unit_facilites', function(Blueprint $table) {
			$table->dropForeign('unit_facilites_unit_id_foreign');
		});
		Schema::table('unit_marks', function(Blueprint $table) {
			$table->dropForeign('unit_marks_mark_id_foreign');
		});
		Schema::table('unit_marks', function(Blueprint $table) {
			$table->dropForeign('unit_marks_unit_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_country_id_foreign');
		});
		Schema::table('unit_reservations', function(Blueprint $table) {
			$table->dropForeign('unit_reservations_client_id_foreign');
		});
		Schema::table('unit_reservations', function(Blueprint $table) {
			$table->dropForeign('unit_reservations_unit_id_foreign');
		});
		Schema::table('unit_reservations', function(Blueprint $table) {
			$table->dropForeign('unit_reservations_period_id_foreign');
		});
		Schema::table('unit_payments', function(Blueprint $table) {
			$table->dropForeign('unit_payments_unit_id_foreign');
		});
		Schema::table('unit_payments', function(Blueprint $table) {
			$table->dropForeign('unit_payments_payment_method_id_foreign');
		});
	}
}