<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitMarksTable extends Migration {

	public function up()
	{
		Schema::create('unit_marks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('mark_id')->unsigned()->nullable();
			$table->integer('unit_id')->unsigned()->nullable();
			$table->boolean('is_master')->nullable();
			$table->string('title')->nullable();
			$table->string('distance')->nullable();
			$table->string('order')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('unit_marks');
	}
}