<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_type_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->string('slug');
			$table->string('name');
			$table->text('description');
			$table->boolean('is_optional')->default(0);
			$table->float('price');
			$table->float('renewal_price')->nullable();
			$table->json('meta')->nullable();
			$table->float('min_hours')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}