<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisitorTable extends Migration {

	public function up()
	{
		Schema::create('visitor', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('type');
			$table->timestamps();
			$table->timestamps();
			$table->string('full_name');
			$table->string('email');
			$table->bigInteger('user_id')->unsigned();
			$table->text('notes');
			$table->string('address');
			$table->bigInteger('phone');
			$table->string('photo')->nullable();
			$table->string('company_name')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('visitor');
	}
}