<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->integer('country_id')->unsigned();
			$table->string('mobile', 255)->nullable();
			$table->string('license_number')->nullable();
			$table->string('iata', 255)->nullable();
			$table->string('address', 255)->nullable();
			$table->float('current_balance')->nullable();
			$table->string('username', 255)->nullable();
			$table->string('password', 255)->nullable();
			$table->string('logo', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}