<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVesselRoutesTable extends Migration {

	public function up()
	{
		Schema::create('vessel_routes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('from')->unsigned();
			$table->integer('to')->unsigned();
			$table->integer('distination')->unsigned()->nullable();
			$table->integer('vessel_id')->unsigned()->nullable();
			$table->enum('schedule', array('yes', 'no'))->nullable();
			$table->date('schedule_date')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vessel_routes');
	}
}