<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Download extends Model 
{

    protected $table = 'downloads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title_pt', 'title_en', 'thumbnail', 'link', 'exclusive', 'download_type_id');

    public function downloadTypes()
    {
        return $this->belongsTo('DownloadType', 'download_type_id');
    }

}