<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductModel extends Model 
{

    protected $table = 'product_models';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_PT', 'name_EN', 'image', 'exclusive', 'product_line_id');

    public function productLine()
    {
        return $this->belongsTo('ProductLine', 'product_line_id');
    }

    public function products()
    {
        return $this->hasManyThrough('Product', 'ProductType', 'product_model_id', 'product_type_id');
    }

    public function productModelImages()
    {
        return $this->hasMany('ProductModelImage', 'product_model_id');
    }

    public function productTypes()
    {
        return $this->hasMany('ProductType', 'product_model_id');
    }

    public function productDrawings()
    {
        return $this->hasManyThrough('ProductDrawing', 'ProductType', 'product_model_id', 'product_type_id');
    }

}