<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('active', 'username', 'password', 'email', 'user_role_id', 'fullname', 'social_name', 'address', 'CNPJ', 'IE', 'phone_number');

    public function userRole()
    {
        return $this->belongsTo('UserRole', 'user_role_id');
    }

    public function CityRegion()
    {
        return $this->belongsTo('CityRegion', 'city_and_region_id');
    }

}