<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('active');
			$table->string('username', 64);
			$table->string('password', 512);
			$table->string('email', 128);
			$table->integer('user_role_id')->unsigned();
			$table->string('fullname', 256);
			$table->string('social_name', 256);
			$table->string('address', 1024)->nullable();
			$table->string('CNPJ', 32)->nullable();
			$table->string('IE', 32)->nullable();
			$table->string('phone_number', 32)->nullable();
			$table->integer('city_and_region_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}