<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->double('transaction_fees')->nullable();
			$table->double('payment_processing')->nullable();
			$table->integer('status')->nullable()->default('1');
			$table->integer('parent_id')->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}