<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('auctions_id')->index();
			$table->string('name', 255)->nullable();
			$table->double('price')->nullable();
			$table->double('duration_per_mintues')->nullable();
			$table->string('material', 255)->nullable();
			$table->string('color', 255)->nullable();
			$table->string('size', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}