<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFacebookStatusesTable extends Migration {

	public function up()
	{
		Schema::create('facebook_statuses', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->text('text')->nullable();
			$table->integer('timestamp');
			$table->integer('likes')->nullable();
			$table->integer('comments')->nullable();
			$table->integer('shares')->nullable();
			$table->string('post_id', 500);
			$table->integer('facebook_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('facebook_statuses');
	}
}