<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateYoutubesTable extends Migration {

	public function up()
	{
		Schema::create('youtubes', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->string('name', 1000)->nullable();
			$table->text('description')->nullable();
			$table->string('username', 1000)->nullable();
			$table->integer('followers')->nullable();
			$table->integer('views')->nullable();
			$table->float('engagement_rate', 40,20)->nullable();
			$table->float('average_likes', 40,20)->nullable();
			$table->float('average_views', 40,20)->nullable();
			$table->float('average_comments', 40,20)->nullable();
			$table->integer('influencer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('youtubes');
	}
}