<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('book_id')->unsigned();
			$table->bigInteger('order_id')->unsigned();
			$table->tinyInteger('quantity')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}