<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chat extends Model 
{

    protected $table = 'chats';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function project()
    {
        return $this->belongsTo('App\Project', 'project_id');
    }

    public function partner()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

    public function user()
    {
        return $this->belongsTo('App\User', 'partner_id');
    }

}