<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function details()
	{
		return $this->hasOne('App\UserDetails', 'user_id');
	}

	public function role()
	{
		return $this->belongsTo('App\Role', 'role_id');
	}

	public function type()
	{
		return $this->belongsTo('App\Type', 'type_id');
	}

}