<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDemarchesTable extends Migration {

	public function up()
	{
		Schema::create('demarches', function(Blueprint $table) {
			$table->increments('id');
			$table->string('titre');
			$table->boolean('a_la_une')->default(0);
			$table->text('resume')->nullable();
			$table->text('description')->nullable();
			$table->mediumText('body')->nullable();
			$table->text('post_scriptum')->nullable();
			$table->string('mot_cle')->nullable();
			$table->text('observations')->nullable();
			$table->string('etat', 30);
			$table->boolean('est_publie')->default(0);
			$table->string('url')->nullable();
			$table->double('cout')->nullable();
			$table->smallInteger('delai')->unsigned()->nullable();
			$table->boolean('teleprocedure')->default(0);
			$table->datetime('date_publication')->nullable();
			$table->datetime('date_derniere_modification')->nullable();
			$table->bigInteger('add_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('demarches');
	}
}