<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePointWifisTable extends Migration {

	public function up()
	{
		Schema::create('point_wifis', function(Blueprint $table) {
			$table->increments('id');
			$table->string('libelle');
			$table->string('code_collectivite', 30)->nullable();
			$table->string('lattiude')->nullable();
			$table->string('longitude')->nullable();
			$table->string('altitude')->nullable();
			$table->boolean('est_actif')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('point_wifis');
	}
}