<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceAdministratifsTable extends Migration {

	public function up()
	{
		Schema::create('service_administratifs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nom');
			$table->string('sigle', 25)->nullable();
			$table->integer('parent_id')->unsigned()->nullable();
			$table->string('adresse')->nullable();
			$table->string('boite_postale', 50)->nullable();
			$table->string('ville')->nullable();
			$table->string('region')->nullable();
			$table->integer('pays_id')->unsigned()->nullable();
			$table->string('telephone')->nullable();
			$table->string('fax')->nullable();
			$table->string('email')->nullable();
			$table->string('site_web')->nullable();
			$table->text('description')->nullable();
			$table->text('acces')->nullable();
			$table->text('remarque')->nullable();
			$table->string('observations')->nullable();
			$table->integer('type_service_administratif_id')->unsigned()->nullable();
			$table->string('lattiude')->nullable();
			$table->string('longitude')->nullable();
			$table->string('altitude')->nullable();
			$table->string('etat', 50);
			$table->boolean('est_publie')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('service_administratifs');
	}
}