<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('themes', function(Blueprint $table) {
			$table->foreign('espace_id')->references('id')->on('espaces')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('demarches', function(Blueprint $table) {
			$table->foreign('add_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('demarche_sous_themes', function(Blueprint $table) {
			$table->foreign('demarche_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demarche_sous_themes', function(Blueprint $table) {
			$table->foreign('sous_theme_id')->references('id')->on('sous_themes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('log_demarches', function(Blueprint $table) {
			$table->foreign('demarche_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('log_demarches', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('demarche_tags', function(Blueprint $table) {
			$table->foreign('demarche_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demarche_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('theme_sous_themes', function(Blueprint $table) {
			$table->foreign('theme_id')->references('id')->on('themes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('theme_sous_themes', function(Blueprint $table) {
			$table->foreign('sous_theme_id')->references('id')->on('sous_themes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('textes', function(Blueprint $table) {
			$table->foreign('type_texte_id')->references('id')->on('type_textes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('textes', function(Blueprint $table) {
			$table->foreign('add_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('demarche_textes', function(Blueprint $table) {
			$table->foreign('demarche_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demarche_textes', function(Blueprint $table) {
			$table->foreign('texte_id')->references('id')->on('textes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('formulaires', function(Blueprint $table) {
			$table->foreign('add_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('demarche_formulaires', function(Blueprint $table) {
			$table->foreign('demarche_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demarche_formulaires', function(Blueprint $table) {
			$table->foreign('formulaire_id')->references('id')->on('formulaires')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demarche_faqs', function(Blueprint $table) {
			$table->foreign('demarche_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demarche_faqs', function(Blueprint $table) {
			$table->foreign('faq_id')->references('id')->on('faqs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demarche_modele_lettres', function(Blueprint $table) {
			$table->foreign('demarche_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demarche_modele_lettres', function(Blueprint $table) {
			$table->foreign('modele_lettre_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_administratifs', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('service_administratifs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_administratifs', function(Blueprint $table) {
			$table->foreign('pays_id')->references('id')->on('pays')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_administratifs', function(Blueprint $table) {
			$table->foreign('type_service_administratif_id')->references('id')->on('type_service_administratifs')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('demarche_services', function(Blueprint $table) {
			$table->foreign('demarche_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demarche_services', function(Blueprint $table) {
			$table->foreign('service_administratif_id')->references('id')->on('service_administratifs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('actualite_sous_themes', function(Blueprint $table) {
			$table->foreign('actualite_id')->references('id')->on('actualites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('actualite_sous_themes', function(Blueprint $table) {
			$table->foreign('sous_theme_id')->references('id')->on('sous_themes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('actualite_demarches', function(Blueprint $table) {
			$table->foreign('actualite_id')->references('id')->on('actualites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('actualite_demarches', function(Blueprint $table) {
			$table->foreign('demarche_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('actualite_service_administratifs', function(Blueprint $table) {
			$table->foreign('actualite_id')->references('id')->on('actualites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('actualite_service_administratifs', function(Blueprint $table) {
			$table->foreign('service_administratif_id')->references('id')->on('service_administratifs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('actualite_textes', function(Blueprint $table) {
			$table->foreign('actualite_id')->references('id')->on('actualites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('actualite_textes', function(Blueprint $table) {
			$table->foreign('texte_id')->references('id')->on('textes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('piece_jointes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('info_generales', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('demarche_lies', function(Blueprint $table) {
			$table->foreign('demarche_parent_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('demarche_lies', function(Blueprint $table) {
			$table->foreign('demarche_child_id')->references('id')->on('demarches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('site_webs', function(Blueprint $table) {
			$table->foreign('service_administratif_id')->references('id')->on('service_administratifs')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('themes', function(Blueprint $table) {
			$table->dropForeign('themes_espace_id_foreign');
		});
		Schema::table('demarches', function(Blueprint $table) {
			$table->dropForeign('demarches_add_by_foreign');
		});
		Schema::table('demarche_sous_themes', function(Blueprint $table) {
			$table->dropForeign('demarche_sous_themes_demarche_id_foreign');
		});
		Schema::table('demarche_sous_themes', function(Blueprint $table) {
			$table->dropForeign('demarche_sous_themes_sous_theme_id_foreign');
		});
		Schema::table('log_demarches', function(Blueprint $table) {
			$table->dropForeign('log_demarches_demarche_id_foreign');
		});
		Schema::table('log_demarches', function(Blueprint $table) {
			$table->dropForeign('log_demarches_user_id_foreign');
		});
		Schema::table('demarche_tags', function(Blueprint $table) {
			$table->dropForeign('demarche_tags_demarche_id_foreign');
		});
		Schema::table('demarche_tags', function(Blueprint $table) {
			$table->dropForeign('demarche_tags_tag_id_foreign');
		});
		Schema::table('theme_sous_themes', function(Blueprint $table) {
			$table->dropForeign('theme_sous_themes_theme_id_foreign');
		});
		Schema::table('theme_sous_themes', function(Blueprint $table) {
			$table->dropForeign('theme_sous_themes_sous_theme_id_foreign');
		});
		Schema::table('textes', function(Blueprint $table) {
			$table->dropForeign('textes_type_texte_id_foreign');
		});
		Schema::table('textes', function(Blueprint $table) {
			$table->dropForeign('textes_add_by_foreign');
		});
		Schema::table('demarche_textes', function(Blueprint $table) {
			$table->dropForeign('demarche_textes_demarche_id_foreign');
		});
		Schema::table('demarche_textes', function(Blueprint $table) {
			$table->dropForeign('demarche_textes_texte_id_foreign');
		});
		Schema::table('formulaires', function(Blueprint $table) {
			$table->dropForeign('formulaires_add_by_foreign');
		});
		Schema::table('demarche_formulaires', function(Blueprint $table) {
			$table->dropForeign('demarche_formulaires_demarche_id_foreign');
		});
		Schema::table('demarche_formulaires', function(Blueprint $table) {
			$table->dropForeign('demarche_formulaires_formulaire_id_foreign');
		});
		Schema::table('demarche_faqs', function(Blueprint $table) {
			$table->dropForeign('demarche_faqs_demarche_id_foreign');
		});
		Schema::table('demarche_faqs', function(Blueprint $table) {
			$table->dropForeign('demarche_faqs_faq_id_foreign');
		});
		Schema::table('demarche_modele_lettres', function(Blueprint $table) {
			$table->dropForeign('demarche_modele_lettres_demarche_id_foreign');
		});
		Schema::table('demarche_modele_lettres', function(Blueprint $table) {
			$table->dropForeign('demarche_modele_lettres_modele_lettre_id_foreign');
		});
		Schema::table('service_administratifs', function(Blueprint $table) {
			$table->dropForeign('service_administratifs_parent_id_foreign');
		});
		Schema::table('service_administratifs', function(Blueprint $table) {
			$table->dropForeign('service_administratifs_pays_id_foreign');
		});
		Schema::table('service_administratifs', function(Blueprint $table) {
			$table->dropForeign('service_administratifs_type_service_administratif_id_foreign');
		});
		Schema::table('demarche_services', function(Blueprint $table) {
			$table->dropForeign('demarche_services_demarche_id_foreign');
		});
		Schema::table('demarche_services', function(Blueprint $table) {
			$table->dropForeign('demarche_services_service_administratif_id_foreign');
		});
		Schema::table('actualite_sous_themes', function(Blueprint $table) {
			$table->dropForeign('actualite_sous_themes_actualite_id_foreign');
		});
		Schema::table('actualite_sous_themes', function(Blueprint $table) {
			$table->dropForeign('actualite_sous_themes_sous_theme_id_foreign');
		});
		Schema::table('actualite_demarches', function(Blueprint $table) {
			$table->dropForeign('actualite_demarches_actualite_id_foreign');
		});
		Schema::table('actualite_demarches', function(Blueprint $table) {
			$table->dropForeign('actualite_demarches_demarche_id_foreign');
		});
		Schema::table('actualite_service_administratifs', function(Blueprint $table) {
			$table->dropForeign('actualite_service_administratifs_actualite_id_foreign');
		});
		Schema::table('actualite_service_administratifs', function(Blueprint $table) {
			$table->dropForeign('actualite_service_administratifs_service_administratif_id_foreign');
		});
		Schema::table('actualite_textes', function(Blueprint $table) {
			$table->dropForeign('actualite_textes_actualite_id_foreign');
		});
		Schema::table('actualite_textes', function(Blueprint $table) {
			$table->dropForeign('actualite_textes_texte_id_foreign');
		});
		Schema::table('piece_jointes', function(Blueprint $table) {
			$table->dropForeign('piece_jointes_user_id_foreign');
		});
		Schema::table('info_generales', function(Blueprint $table) {
			$table->dropForeign('info_generales_updated_by_foreign');
		});
		Schema::table('demarche_lies', function(Blueprint $table) {
			$table->dropForeign('demarche_lies_demarche_parent_id_foreign');
		});
		Schema::table('demarche_lies', function(Blueprint $table) {
			$table->dropForeign('demarche_lies_demarche_child_id_foreign');
		});
		Schema::table('site_webs', function(Blueprint $table) {
			$table->dropForeign('site_webs_service_administratif_id_foreign');
		});
	}
}