<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActualitesTable extends Migration {

	public function up()
	{
		Schema::create('actualites', function(Blueprint $table) {
			$table->increments('id');
			$table->text('titre');
			$table->text('description')->nullable();
			$table->text('contenu')->nullable();
			$table->string('url')->nullable();
			$table->text('observations')->nullable();
			$table->datetime('date_publication')->nullable();
			$table->datetime('date_derniere_modification')->nullable();
			$table->string('etat', 50);
			$table->boolean('est_publie')->default(0);
			$table->bigInteger('add_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('actualites');
	}
}