<?php

namespace App\Models\Demarches;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServiceAdministratif extends Eloquent {

	protected $table = 'service_administratifs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nom', 'sigle', 'parent_id', 'adresse', 'boite_postale', 'ville', 'region', 'pays_id', 'telephone', 'fax', 'email', 'site_web', 'description', 'acces', 'remarque', 'observations', 'type_service_administratif_id', 'lattiude', 'longitude', 'altitude', 'etat', 'est_publie');

	public function demarches()
	{
		return $this->belongsToMany('App\Models\Demarches\Demarche');
	}

	public function actualites()
	{
		return $this->belongsToMany('App\Models\Demarches\Actualite');
	}

	public function parent()
	{
		return $this->belongsTo('App\Models\Demarches\ServiceAdministratif', 'parent_id');
	}

	public function pays()
	{
		return $this->belongsTo('App\Models\Demarches\Pays', 'pays_id');
	}

	public function type()
	{
		return $this->belongsTo('App\Models\Demarches\TypeServiceAdministratif');
	}

}