<?php

namespace App\Models\Demarches;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Texte extends Eloquent {

	protected $table = 'textes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nom', 'description', 'url', 'fichier', 'observations', 'type_texte_id', 'etat', 'est_publie', 'date_publication', 'date_derniere_modification', 'add_by');

	public function type()
	{
		return $this->belongsTo('App\Models\Demarches\TypeTexte');
	}

	public function demarches()
	{
		return $this->belongsToMany('App\Models\Demarches\Demarche');
	}

	public function actualites()
	{
		return $this->belongsToMany('App\Models\Demarches\Actualite');
	}

}