<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyTable extends Migration {

	public function up()
	{
		Schema::create('property', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('owner_id')->unsigned();
			$table->integer('locution_id')->unsigned();
			$table->integer('property_type')->unsigned();
			$table->integer('property_status')->unsigned();
			$table->float('price');
			$table->string('is_price_negotiable');
			$table->string('age');
			$table->string('orientation');
			$table->integer('number_of_streets_around');
			$table->integer('number_of_rooms');
			$table->integer('number_of_bathroom');
			$table->integer('number_of_dining');
			$table->integer('number_of_windows');
			$table->string('square_footage');
			$table->date('availibility_date');
			$table->string('has_built_in_kitchen');
			$table->string('has_air_conditioning');
			$table->string('has_helper_room');
			$table->string('furnisheh');
			$table->string('has_pool');
			$table->string('has_driving');
			$table->string('has_basement');
			$table->string('has_garage');
			$table->string('has_garden');
			$table->string('has_elevator');
			$table->string('has_terrace');
			$table->string('has_fireplace');
			$table->string('has_ularm');
			$table->string('has_gym');
			$table->string('has_swimming');
			$table->string('payment_option');
			$table->string('allow_buy_or_sell');
			$table->string('image');
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('property');
	}
}