<?php

namespace App\Model;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('login', 'email', 'avatar');
	protected $visible = array('login', 'email', 'avatar');

	public function role()
	{
		return $this->hasOne('App\Model\Role');
	}

	public function posts()
	{
		return $this->belongsToMany('App\Model\Post');
	}

	public function tuto()
	{
		return $this->belongsToMany('App\Model\Tuto');
	}

}