<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'email_address', 'phone');

	public function roles()
	{
		return $this->hasManyThrough('Roles', 'user_roles');
	}

	public function organisations()
	{
		return $this->hasManyThrough('Organisation', 'user_organisations');
	}

}