<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->tinyInteger('is_admin');
			$table->string('password');
			$table->string('phone');
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('blood_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}