<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Admin extends Model 
{

    protected $table = 'admins';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function roles()
    {
        return $this->morphToMany('Role');
    }

    public function admin_meta()
    {
        return $this->hasMany('AdminMeta');
    }

}