<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderProductReletion extends Model 
{

    protected $table = 'order_product_reletion';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function products()
    {
        return $this->belongsToMany('Product');
    }

    public function order()
    {
        return $this->belongsToMany('Role');
    }

}