<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email')->index();
			$table->string('password');
			$table->text('two_factor_secret')->nullable();
			$table->timestamp('email_verified_at')->nullable();
			$table->text('two_factor_recovery_codes')->nullable();
			$table->string('remember_token')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}