<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductAttribute extends Eloquent {

	protected $table = 'product_attributes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function products()
	{
		return $this->belongsToMany('ProductAttributeReletionship', 'product_id')->withTimestamps();
	}

	public function values()
	{
		return $this->hasMany('ProductAttributeValues');
	}

}